
rng(2002) ;

%%%%%%%%%%%%%%%
% simulations %
%%%%%%%%%%%%%%%

x_liftoff = zeros(Nsimul,6) ;
pi_liftoff = zeros(Nsimul,6) ;
t_liftoff = zeros(Nsimul,6) ;
mean_abs_x = zeros(Nsimul,6) ;
mean_abs_pi = zeros(Nsimul,6) ;
std_x = zeros(Nsimul,6) ;
std_pi = zeros(Nsimul,6) ;
is_reversal = zeros(Nsimul,6) ;
std_di = zeros(Nsimul,6) ;
std_i = zeros(Nsimul,6) ;
length_reversal = zeros(Nsimul,6) ;
neverleavesZLB = zeros(Nsimul,6) ;
maxpi = zeros(Nsimul,6) ;
minpi = zeros(Nsimul,6) ;
maxx = zeros(Nsimul,6) ;
minx = zeros(Nsimul,6) ;

i_pathSS = zeros(T,Nsimul) ;
x_pathSS = zeros(T,Nsimul) ;
pi_pathSS = zeros(T,Nsimul) ;
eps_path = zeros(T,Nsimul) ;
u_path = zeros(T,Nsimul) ;

median_i_path = zeros(T,6) ;
median_x_path = zeros(T,6) ;
median_pi_path = zeros(T,6) ;
mean_i_path = zeros(T,6) ;
mean_x_path = zeros(T,6) ;
mean_pi_path = zeros(T,6) ;

indicRNR = zeros(Nsimul,6) ;

disp('simulating...')

for i=1:Nsimul
    % assume we start at 0,0:
    eps_path(1:T,i) = simmarkovgiveinit(P_eps,T,feps) ;
    u_path(1:T,i) = simmarkovgiveinit(P_u,T,fu) ;
end

varm = 'linear' ; % interpolation method for policy functions

for vvv2=1:6 ;
    
    if vvv2==1; x_polSS = x_polK(:,:,:,:,:,3)  ; pi_polSS = pi_polK(:,:,:,:,:,3) ;  int_pol_SS = int_polK(:,:,:,:,:,3) ;  end
    if vvv2==2; x_polSS = x_polKA(:,:,:,:,:,3) ; pi_polSS = pi_polKA(:,:,:,:,:,3) ; int_pol_SS = int_polKA(:,:,:,:,:,3) ; end
    if vvv2==3; x_polSS = x_polKB(:,:,:,:,:,3) ; pi_polSS = pi_polKB(:,:,:,:,:,3) ; int_pol_SS = int_polKB(:,:,:,:,:,3) ; end
    if vvv2==4; x_polSS = x_polKC(:,:,:,:,:,3) ; pi_polSS = pi_polKC(:,:,:,:,:,3) ; int_pol_SS = int_polKC(:,:,:,:,:,3) ; end
    if vvv2==5; x_polSS = x_poldumbK(:,:,:,:,:,3)  ; pi_polSS = pi_poldumbK(:,:,:,:,:,3) ; int_pol_SS = int_poldumbK(:,:,:,:,:,3) ; end
    if vvv2==6; x_polSS = x_polK(:,:,:,:,:,1)  ; pi_polSS = pi_polK(:,:,:,:,:,1) ;  int_pol_SS = int_polK(:,:,:,:,:,1) ;  end

    
    %%% simulate path starting from x0,pi0, assuming zero shocks %%%
    
    for t=1:T
        if t>1
            for e=1:n_eps
                for u=1:n_u
                    f = find(eps_path(t,:)==e&u_path(t,:)==u) ;
                    i_pathSS(t,f)  = interp2(grid_pi,grid_x,int_pol_SS(:,:,t,e,u),pi_pathSS(t-1,f),x_pathSS(t-1,f),varm) ;
                    x_pathSS(t,f)  = interp2(grid_pi,grid_x,x_polSS(:,:,t,e,u),pi_pathSS(t-1,f),x_pathSS(t-1,f),varm) ;
                    pi_pathSS(t,f) = interp2(grid_pi,grid_x,pi_polSS(:,:,t,e,u),pi_pathSS(t-1,f),x_pathSS(t-1,f),varm) ;
                end
            end
        else
            i_pathSS(t,1:Nsimul)  = interp2(grid_pi,grid_x,int_pol_SS(:,:,t,feps,fu),pi0,x0,varm) ;
            x_pathSS(t,1:Nsimul)  = interp2(grid_pi,grid_x,x_polSS(:,:,t,feps,fu),pi0,x0,varm) ;
            pi_pathSS(t,1:Nsimul) = interp2(grid_pi,grid_x,pi_polSS(:,:,t,feps,fu),pi0,x0,varm) ;
        end
        x_pathSS(t,:) = max(lx,x_pathSS(t,:)) ;
        pi_pathSS(t,:) = max(lpi,pi_pathSS(t,:)) ;
    end
    
    pi_pathSS = 400*(pi_pathSS+pistar) ;
    x_pathSS = 100*x_pathSS ;
    i_pathSS = 400*i_pathSS+400*pistar ; % annualize the interest rate, take out hte constant - i.e. 0.1 is 10% annual now.
    
    for i=1:Nsimul;
        
        if max(i_pathSS(:,i))<thresholdzlb;
            first_liftoff = Ts1 + 1 ;
            neverleavesZLB(i,vvv2) =  1 ;
            is_reversal(i,vvv2) = - 1 ;
            length_reversal(i,vvv2) = - 1 ;
            x_liftoff(i,vvv2) =  NaN ;
            pi_liftoff(i,vvv2) =  NaN ;
        else
            neverleavesZLB(i,vvv2) =  0 ;
            first_liftoff = find(i_pathSS(:,i)>=thresholdzlb, 1, 'first' ) ;
            x_liftoff(i,vvv2) =  x_pathSS(first_liftoff,i) ;
            pi_liftoff(i,vvv2) =  pi_pathSS(first_liftoff,i) ;
            if min(i_pathSS(first_liftoff:T11,i))<thresholdzlb
                is_reversal(i,vvv2) =  1 ;
                length_reversal(i,vvv2) = sum( (i_pathSS(first_liftoff:T11,i) < thresholdzlb) ) ;
            else
                is_reversal(i,vvv2) =  0 ;
                length_reversal(i,vvv2) = 0 ;
            end
        end
        
        t_liftoff(i,vvv2) = first_liftoff ;
        
        
        % indicator that real natural rate is negative the period after liftoff.
        if first_liftoff>=1&&first_liftoff<T11-1
            if grid_eps(eps_path(first_liftoff+1,i))*sigma_eps*scalefactor(t) + rhomean(first_liftoff+1) <= 0 ;
                indicRNR(i,vvv2) = 1 ;
            end
        else
            indicRNR(i,vvv2) = NaN ;
        end
        
        mean_abs_x(i,vvv2) = mean(abs(x_pathSS(:,i))) ;
        mean_abs_pi(i,vvv2) = mean(abs(pi_pathSS(:,i))) ;
        std_x(i,vvv2) = std(x_pathSS(:,i)) ;
        std_pi(i,vvv2) = std(pi_pathSS(:,i)) ;
        std_di(i,vvv2) = std(i_pathSS(2:end,i)-i_pathSS(1:end-1,i)) ;
        std_i(i,vvv2) = std(i_pathSS(:,i)) ;
        
        
        maxpi(i,vvv2) = max(pi_pathSS(1:T11,i)) ;
        minpi(i,vvv2) = min(pi_pathSS(1:T11,i)) ;
        maxx(i,vvv2) = max(x_pathSS(1:T11,i))   ;
        minx(i,vvv2) = min(x_pathSS(1:T11,i))   ;
    end
    
    for t=1:T
        median_i_path(t,vvv2) = nanmedian(i_pathSS(t,:)) ;
        median_x_path(t,vvv2) = nanmedian(x_pathSS(t,:)) ;
        median_pi_path(t,vvv2) = nanmedian(pi_pathSS(t,:)) ;
        mean_i_path(t,vvv2) = nanmean(i_pathSS(t,:)) ;
        mean_x_path(t,vvv2) = nanmean(x_pathSS(t,:)) ;
        mean_pi_path(t,vvv2) = nanmean(pi_pathSS(t,:)) ;
    end
    
    
    %             clear int_pol_SS pi_polSS int_pol_SS
    %             clear pi_pathSS x_pathSS i_pathSS
end


% calculate loss at time 0 -
L1 = interp2(grid_pi,grid_x,VK(:,:,1,feps,fu,3),pi0,x0,'linear') ;
L2 = interp2(grid_pi,grid_x,lossKA(:,:,1,feps,fu,3),pi0,x0,'linear') ;
L3 = interp2(grid_pi,grid_x,lossKB(:,:,1,feps,fu,3),pi0,x0,'linear') ;
L4=  interp2(grid_pi,grid_x,lossKC(:,:,1,feps,fu,3),pi0,x0,'linear') ;
L5=  interp2(grid_pi,grid_x,VK(:,:,1,feps,fu,1),pi0,x0,'linear') ;
L6=  interp2(grid_pi,grid_x,VdumbK(:,:,1,feps,fu,3),pi0,x0,'linear') ;
AX = 1600*[L1,L2,L3,L4,L6,L5] ;

X1k = zeros(1,6) ;
X1kSD = zeros(1,6) ;
X2k = zeros(1,6) ;
X2kSD = zeros(1,6) ;
X3k = zeros(1,6) ;
X3kSD = zeros(1,6) ;

for us=1:6 ;
    TT = find(is_reversal(is_reversal(:,us)>-.5)) ;
    X1k(us) = nanmean(is_reversal(TT,us)) ;
    X1kSD(us) = std(is_reversal(TT,us)) ;
    TT = find(length_reversal(:,us)>=0.5) ;
    TT2 = find(length_reversal(:,us)>=-0.5) ;
    X2k(us) = nanmean(length_reversal(TT,us)) ;
    X2kSD(us) = std(length_reversal(TT,us)) ;
    X3k(us) = nanmean(length_reversal(TT2,us)) ;
    X3kSD(us) = std(length_reversal(TT2,us)) ;
    p95maxpi(us) = prctile(maxpi(:,us),95) ;
    p90maxpi(us) = prctile(maxpi(:,us),90) ;
    p75maxpi(us) = prctile(maxpi(:,us),75) ;
    p10maxpi(us) = prctile(maxpi(:,us),10) ;
    p5maxpi(us) = prctile(maxpi(:,us),5) ;
    
    p95maxx(us) = prctile(maxx(:,us),95) ;
    p90maxx(us) = prctile(maxx(:,us),90) ;
    p10maxx(us) = prctile(maxx(:,us),10) ;
    p5maxx(us) = prctile(maxx(:,us),5) ;
    
    p95minx(us) = prctile(minx(:,us),95) ;
    p90minx(us) = prctile(minx(:,us),90) ;
    p25minx(us) = prctile(minx(:,us),25) ;
    p10minx(us) = prctile(minx(:,us),10) ;
    p5minx(us) = prctile(minx(:,us),5) ;
    
    p95minpi(us) = prctile(minpi(:,us),95) ;
    p90minpi(us) = prctile(minpi(:,us),90) ;
    p10minpi(us) = prctile(minpi(:,us),10) ;
    p5minpi(us) = prctile(minpi(:,us),5) ;
    
end

% full table -
fmt = ' %6.2f ' ;
head2 = {'Opt. Discr','Nat Rate','Nat Rate + Infl','TR cst int','Naive FedFed','No Unc'} ;
TableShow = [AX;nanmean(t_liftoff);nanmedian(t_liftoff);nanmean(x_liftoff);nanmedian(x_liftoff);nanmean(pi_liftoff);nanmedian(pi_liftoff);p75maxpi;p25minx;nanmean(indicRNR);nanmean(std_di);nanmedian(std_di);nanmean(std_i);nanmedian(std_i) ] ;
row = {'Loss';'Mean time to liftoff';'Median time to liftoff'; 'Mean x at liftoff' ; 'Median x at liftoff' ; 'Mean pi at liftoff';'Median pi at liftoff'; 'p75 of max pi'; 'p25 of min x';'Prob of neg nat rate after liftoff';'mean STD Delta i';'median STD Delta i';'mean STD i';'median STD i'} ;
% texprint(TableShow,fmt, head2, row)

% simpler table --
axa= [1,5,4] ;
axa2 = [1,2,3,7,5,8,9,12];

texprint(TableShow(axa2,axa),fmt, head2(axa), row(axa2))


